<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Item;
use App\Models\Offer;


class MenuController extends Controller
{
    public function showCategory()
    {
        // $categoryName = urldecode($category);

        // $categoryModel = Category::where('name', $categoryName)->first();
        $categories = Category::all();
        $categoriesList = Category::all();
        $items = Item::all();
        $settings = \App\Models\Setting::pluck('value', 'key');
        $offers = Offer::latest()->get();

        if (!$categories) {
            return view('welcome', [
                'categories' => $categories,
                'items' => [],
                'categoryName' => $categoryName,
                'settings' => $settings,
                'offers' => $offers
            ]);
        }

        // $items = $categoryModel->items;

        return view('welcome', compact('categories', 'items', 'categoriesList', 'settings', 'offers'));
    }


    
    public function showItems($category)
    {
        $categoryName = urldecode($category);

        $categoryModel = Category::where('name', $categoryName)->first();
        $categories = Category::all();
        $categoriesList = $categoryName ? Category::where('name', $categoryName)->get() : Category::all();

        if (!$categoryModel) {
            return view('welcome', [
                'categories' => $categories,
                'items' => [],
                'categoryName' => $categoryName
            ]);
        }

        $items = $categoryModel->items;

        return view('welcome', compact('categories', 'items', 'categoryName' ,'categoriesList'));
    }

    public function menuPartial(Request $request)
    {
        $categoryName = $request->get('category');
        $search       = $request->get('search');

        if($categoryName == 'all' || !$categoryName){
            $categoriesList = Category::all();
        } else {
            $categoriesList = Category::where('name', $categoryName)->get();
        }

        $items = Item::query();

        // فلترة بالتصنيف
        if ($categoryName && $categoryName !== 'all') {
            $items->whereHas('category', function($q) use ($categoryName) {
                $q->where('name', $categoryName);
            });
        }

        // فلترة بالبحث
        if ($search) {
            $items->where(function($q) use ($search) {
                $q->where('name', 'like', "%{$search}%")
                ->orWhere('description', 'like', "%{$search}%");
            });
        }

        $items = $items->get();

        return view('menu-container', compact('categoriesList', 'items', 'categoryName'));
    }


}

