<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Restaurant;

class RestaurantAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('restaurant.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
        ]);

        $restaurant = Restaurant::where('username', $request->username)->first();

        if ($restaurant && Hash::check($request->password, $restaurant->password)) {
            // حفظ معلومات الدخول في السيشن
            session(['restaurant_id' => $restaurant->id]);
            return redirect()->route('dashboard')->with('success', 'تم تسجيل الدخول بنجاح');
        }

        return back()->withErrors(['username' => 'بيانات الدخول غير صحيحة'])->withInput();
    }

    public function logout()
    {
        session()->forget('id');
        return redirect()->route('login')->with('success', 'تم تسجيل الخروج');
    }
}
