@extends('dashboard.nav.nav')

@section('title', 'اضافة صنف جديد')

@section('content')
<div class="min-h-screen bg-gray-100 py-10 px-6">
    <div class="max-w-3xl mx-auto bg-white rounded-2xl shadow-lg p-8">
        
        <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center border-b pb-3">
            ➕ إضافة صنف جديد
        </h2>

        {{-- رسائل النجاح والأخطاء --}}
        @if (session('success'))
            <div class="mb-4 p-3 bg-green-100 text-green-700 rounded-lg text-center">
                {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="mb-4 p-3 bg-red-100 text-red-700 rounded-lg">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form class="space-y-6" action="{{ route('items.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            {{-- صورة الصنف --}}
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📸 صورة الصنف</label>
                <input type="file" name="image" accept="image/*" required
                       class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
            </div>

            {{-- الاسم --}}
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📝 الاسم</label>
                <input type="text" name="name" required
                       class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
            </div>

            {{-- الوصف --}}
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📄 وصف الصنف (اختياري)</label>
                <textarea name="description" rows="2"
                          class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500"></textarea>
            </div>

            {{-- نوع السعر --}}
            <div class="space-y-2">
                <span class="block font-semibold text-gray-700">💰 نوع السعر</span>
                <div class="flex gap-4">
                    <label class="flex items-center gap-2">
                        <input type="radio" name="price_type" value="single" checked
                               class="text-blue-600 focus:ring-blue-500 toggle-price">
                        <span>سعر واحد</span>
                    </label>
                    <label class="flex items-center gap-2">
                        <input type="radio" name="price_type" value="multiple"
                               class="text-blue-600 focus:ring-blue-500 toggle-price">
                        <span>أكثر من سعر</span>
                    </label>
                </div>
            </div>

            {{-- السعر الواحد --}}
            <div id="single-price-field">
                <label class="block font-semibold text-gray-700 mb-2">💵 السعر</label>
                <input type="number" step="0.01" name="price"
                       class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
            </div>

            {{-- الأسعار المتعددة --}}
            <div id="multiple-price-fields" class="hidden">
                <label class="block font-semibold text-gray-700 mb-2">💸 الأسعار حسب الحجم</label>

                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-gray-700 mb-1">صغير</label>
                        <input type="number" step="0.01" name="priceS"
                               class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-gray-700 mb-1">وسط</label>
                        <input type="number" step="0.01" name="priceM"
                               class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-gray-700 mb-1">كبير</label>
                        <input type="number" step="0.01" name="priceL"
                               class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                    </div>
                </div>
            </div>

            {{-- القسم --}}
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📂 القسم</label>
                <select name="category_id" required
                        class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>

            {{-- زر الإرسال --}}
            <div class="text-center">
                <button type="submit"
                        class="bg-blue-600 text-white px-6 py-2 rounded-lg shadow hover:bg-blue-700 transition">
                    💾 إضافة الصنف
                </button>
            </div>
        </form>
    </div>
</div>

{{-- سكريبت التحكم في عرض الأسعار --}}
<script>
document.addEventListener("DOMContentLoaded", function () {
    const singleField = document.getElementById("single-price-field");
    const multipleFields = document.getElementById("multiple-price-fields");
    const radios = document.querySelectorAll(".toggle-price");

    radios.forEach(radio => {
        radio.addEventListener("change", function () {
            if (this.value === "single") {
                singleField.classList.remove("hidden");
                multipleFields.classList.add("hidden");
            } else {
                singleField.classList.add("hidden");
                multipleFields.classList.remove("hidden");
            }
        });
    });
});
</script>
@endsection
