<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" type="image/x-icon" href="{{ asset('storage/app/public/' . $restaurant->logo) }}">
    <title>@yield('title', 'لوحة التحكم')</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    

</head>
<body>
    


    <nav class="bg-white shadow-md rounded-b-2xl sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16 items-center">

                <!-- Left: Logout -->
                <div class="flex items-center">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit"
                            class="flex items-center gap-2 bg-red-500 text-white font-semibold px-4 py-2 rounded-lg hover:bg-red-600 transition-transform transform hover:scale-105">
                            <i class="fas fa-sign-out-alt"></i>
                            تسجيل الخروج
                        </button>
                    </form>
                </div>

                <!-- Center: Logo -->
                <div class="flex-shrink-0">
                    <a href="{{ route('dashboard') }}">
                        <img src="{{ asset('storage/app/public/' . $restaurant->logo) }}"
                            alt="Logo"
                            class="h-12 mx-auto transition-transform duration-300 hover:scale-105">
                    </a>
                </div>

                <!-- Right: Links -->
                <div class="flex space-x-4 rtl:space-x-reverse">
                    <a href="{{ route('settings_colors.index') }}"
                        class="flex items-center gap-2 text-gray-700 font-semibold px-3 py-2 rounded-lg hover:bg-gray-100 hover:text-blue-600 transition">
                        🎨 تحديث الألوان
                    </a>
                    <a href="{{ route('settings.update') }}"
                        class="flex items-center gap-2 text-gray-700 font-semibold px-3 py-2 rounded-lg hover:bg-gray-100 hover:text-blue-600 transition">
                        ⚙️ الإعدادات
                    </a>
                </div>

            </div>
        </div>
    </nav>

    @yield('content')




</body>
</html>