


<?php $__env->startSection('title', 'تحديث بيانات المطعم'); ?>

<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-gray-100 py-10 px-4 sm:px-6 lg:px-8">
        <div class="max-w-3xl mx-auto bg-white shadow-xl rounded-2xl p-8">

            <h2 class="text-2xl font-bold text-gray-800 mb-6 border-b pb-3 text-center">
                ⚙️ تحديث بيانات المطعم
            </h2>

            <form method="POST" action="<?php echo e(route('settings.update')); ?>" enctype="multipart/form-data" class="space-y-6">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- اسم المطعم -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">اسم المطعم</label>
                    <input type="text" name="name" required
                        value="<?php echo e(old('name', $restaurant->name)); ?>"
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-500 focus:border-transparent">
                </div>

                <!-- اللوجو -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">اللوجو</label>
                    <input type="file" name="logo" accept="image/*"
                        class="w-full text-gray-700 border border-gray-300 rounded-lg px-3 py-2 cursor-pointer bg-gray-50 focus:outline-none">
                    <?php if($restaurant->logo): ?>
                        <img src="<?php echo e(asset('storage/' . $restaurant->logo)); ?>"
                            alt="Logo" class="h-20 mt-3 rounded-lg shadow-md border">
                    <?php endif; ?>
                </div>

                <!-- بانر -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">البانر</label>
                    <input type="file" name="banner" accept="image/*"
                        class="w-full text-gray-700 border border-gray-300 rounded-lg px-3 py-2 cursor-pointer bg-gray-50 focus:outline-none">
                    <?php if($restaurant->banner): ?>
                        <img src="<?php echo e(asset('storage/' . $restaurant->banner)); ?>"
                            alt="Banner" class="w-full mt-3 rounded-lg shadow-md border">
                    <?php endif; ?>
                </div>

                <!-- حجم اللوجو -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">حجم اللوجو في المنيو بالبكسل (انسب حجم 50)</label>
                    <input type="number" name="logo_size" required
                        value="<?php echo e(old('logo_size', $restaurant->logo_size)); ?>"
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-500 focus:border-transparent">
                </div>

                <!-- اسم المستخدم -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">اسم المستخدم</label>
                    <input type="text" name="username" required
                        value="<?php echo e(old('username', $restaurant->username)); ?>"
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-500 focus:border-transparent">
                </div>

                <!-- كلمة المرور -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">كلمة المرور (اتركه فارغًا إن لم ترغب في تغييره)</label>
                    <input type="password" name="password"
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-500 focus:border-transparent">
                </div>

                <!-- الهاتف -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">رقم الهاتف + مفتاح الدولة</label>
                    <input type="tel" name="phone" required
                        value="<?php echo e(old('phone', $restaurant->phone)); ?>"
                        pattern="^\+[0-9]{1,3}[0-9\s\-]{6,14}$"
                        placeholder="+20 10xxxxxxx"
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-500 focus:border-transparent">
                </div>

                <!-- العملة -->
                <div>
                    <label class="block text-gray-700 font-medium mb-2">العملة</label>
                    <select name="currency" required
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-500 focus:border-transparent">
                        <option value="جنيه" <?php echo e(old('currency', $restaurant->currency) == 'جنيه' ? 'selected' : ''); ?>>جنيه</option>
                        <option value="$" <?php echo e(old('currency', $restaurant->currency) == '$' ? 'selected' : ''); ?>>$</option>
                        <option value="ريال" <?php echo e(old('currency', $restaurant->currency) == 'ريال' ? 'selected' : ''); ?>>ريال</option>
                        <option value="درهم" <?php echo e(old('currency', $restaurant->currency) == 'درهم' ? 'selected' : ''); ?>>درهم</option>
                        <option value="ليرة" <?php echo e(old('currency', $restaurant->currency) == 'ليرة' ? 'selected' : ''); ?>>ليرة</option>
                        <option value="دينار" <?php echo e(old('currency', $restaurant->currency) == 'دينار' ? 'selected' : ''); ?>>دينار</option>
                    </select>
                </div>

                <!-- زر التحديث -->
                <div class="text-center">
                    <button type="submit"
                        class="bg-green-600 text-white font-semibold px-6 py-3 rounded-xl hover:bg-green-700 transition-all shadow-md hover:shadow-lg">
                        💾 تحديث البيانات
                    </button>
                </div>

                <!-- الأخطاء -->
                <?php if($errors->any()): ?>
                    <div class="bg-red-50 border border-red-300 text-red-600 px-4 py-3 rounded-lg">
                        <ul class="list-disc list-inside space-y-1">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.nav.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\menu-test\resources\views/dashboard/Settings.blade.php ENDPATH**/ ?>