<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $restaurant->logo)); ?>">
    <title><?php echo $__env->yieldContent('title', 'لوحة التحكم'); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    

</head>
<body>
    


    <nav class="bg-white shadow-md rounded-b-2xl sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16 items-center">

                <!-- Left: Logout -->
                <div class="flex items-center">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit"
                            class="flex items-center gap-2 bg-red-500 text-white font-semibold px-4 py-2 rounded-lg hover:bg-red-600 transition-transform transform hover:scale-105">
                            <i class="fas fa-sign-out-alt"></i>
                            تسجيل الخروج
                        </button>
                    </form>
                </div>

                <!-- Center: Logo -->
                <div class="flex-shrink-0">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <img src="<?php echo e(asset('storage/' . $restaurant->logo)); ?>"
                            alt="Logo"
                            class="h-12 mx-auto transition-transform duration-300 hover:scale-105">
                    </a>
                </div>

                <!-- Right: Links -->
                <div class="flex space-x-4 rtl:space-x-reverse">
                    <a href="<?php echo e(route('settings_colors.index')); ?>"
                        class="flex items-center gap-2 text-gray-700 font-semibold px-3 py-2 rounded-lg hover:bg-gray-100 hover:text-blue-600 transition">
                        🎨 تحديث الألوان
                    </a>
                    <a href="<?php echo e(route('settings.update')); ?>"
                        class="flex items-center gap-2 text-gray-700 font-semibold px-3 py-2 rounded-lg hover:bg-gray-100 hover:text-blue-600 transition">
                        ⚙️ الإعدادات
                    </a>
                </div>

            </div>
        </div>
    </nav>

    <?php echo $__env->yieldContent('content'); ?>




</body>
</html><?php /**PATH C:\xampp\htdocs\menu-test\resources\views/dashboard/nav/nav.blade.php ENDPATH**/ ?>