<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Restaurant;
use App\Models\Category;
use App\Models\Item;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;

class DashboardController extends Controller
{
    function index()
    {
        if (!Restaurant::exists()) {
            return redirect()->route('restaurant.register');
        }

        if (!session()->has('restaurant_id')) {
            return redirect()->route('login');
        }

        $categories = Category::all();
        $items = Item::with('category')->get(); // لازم نربط العلاقة دي في موديل Item

        return view('dashboard.dashboard', compact('categories', 'items'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:255',
            'priceS' => 'nullable|numeric',
            'priceM' => 'nullable|numeric',
            'priceL' => 'nullable|numeric',
            'category_id' => 'nullable|exists:categories,id',
        ]);

        Item::create($request->all());

        return redirect()->back()->with('success', 'تمت الإضافة بنجاح');
    }

    public function categories_store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            
        ]);

        Category::create($request->all());

        return redirect()->back()->with('success', 'تمت الإضافة بنجاح');
    }


    public function Settings()
    {
        if (!session()->has('restaurant_id')) {
            return redirect()->route('login');
        }
        $restaurants = Restaurant::first();
        return view('dashboard.Settings', compact('restaurants'));
    }



    public function Settings_update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'username' => 'required|string|max:255',
            'password' => 'nullable|string|min:6',
            'logo' => 'nullable|image|mimes:webp,jpg,jpeg,png|max:2048',
            'logo_size' => 'required|numeric|min:1|max:100',
        ]);

        $restaurant = Restaurant::first(); // أو حسب حالتك

        $restaurant->name = $request->name;
        $restaurant->username = $request->username;
        $restaurant->logo_size = $request->logo_size;

        // تحديث الباسورد لو اتكتب جديد
        if ($request->filled('password')) {
            $restaurant->password = Hash::make($request->password);
        }

        // تحديث اللوجو لو اتغير
        if ($request->hasFile('logo')) {
            // حذف القديم
            if ($restaurant->logo) {
                Storage::disk('public')->delete($restaurant->logo);
            }

            $restaurant->logo = $request->file('logo')->store('logos', 'public');
        }

        $restaurant->save();

        return redirect()->back()->with('success', 'تم تحديث بيانات المطعم بنجاح');
    }


    // إظهار النموذج
    public function edit($id)
    {
        if (!session()->has('restaurant_id')) {
            return redirect()->route('login');
        }
        $item = Item::findOrFail($id);
        $categories = Category::all();
        return view('dashboard.edit_items', compact('item', 'categories'));
    }

    public function categories_edit($id)
    {
        if (!session()->has('restaurant_id')) {
            return redirect()->route('login');
        }
        $category = Category::findOrFail($id);
        // return view('dashboard.edit_categories', compact('category'));

        // $categories = Category::all();
        return view('dashboard.edit_categories', compact('category'));
    }

    public function categories_update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $category = Category::findOrFail($id);
        $category->update($request->only(['name']));

        return redirect()->back()->with('success', 'تم تحديث القسم بنجاح');
    }

    // تحديث البيانات
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:255',
            'priceS' => 'nullable|numeric',
            'priceM' => 'nullable|numeric',
            'priceL' => 'nullable|numeric',
            'category_id' => 'nullable|exists:categories,id',
        ]);

        $item = Item::findOrFail($id);
        $item->update($request->only(['name', 'description', 'priceS', 'priceM', 'priceL', 'category_id']));

        return redirect()->back()->with('success', 'تم تحديث المنتج بنجاح');
    }


    public function add_items()
    {
        if (!session()->has('restaurant_id')) {
            return redirect()->route('login');
        }
        $categories = Category::all();
        return view('dashboard.add_items', compact('categories'));
    }

    public function add_categories()
    {
        if (!session()->has('restaurant_id')) {
            return redirect()->route('login');
        }
        return view('dashboard.add_categories');
    }


    public function destroy($id)
    {
        $item = Item::findOrFail($id);
        $item->delete();

        return redirect()->route('dashboard.dashboard')->with('success', 'تم حذف المنتج بنجاح');
    }

    public function categories_destroy($id)
    {
        $category = Category::findOrFail($id);
        $category->delete();

        return redirect()->route('dashboard')->with('success', 'تم حذف القسم بنجاح');
    }
}
