<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Item;

class MenuController extends Controller
{
    public function showCategory($category)
    {
        $categoryName = urldecode($category);

        $categoryModel = Category::where('name', $categoryName)->first();
        $categories = Category::all();

        if (!$categoryModel) {
            return view('welcome', [
                'categories' => $categories,
                'items' => [],
                'categoryName' => $categoryName
            ]);
        }

        $items = $categoryModel->items;

        return view('welcome', compact('categories', 'items', 'categoryName'));
    }
}

