<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        .add-item-form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            max-width: 600px;
            margin: auto;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-top: 50px;
            display: flex;
            flex-direction: column;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #212529;
        }

        input[type="text"],
        input[type="number"],
        select {
            /* width: 100%; */
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            margin-top: 5px;
        }

        button {
            margin-top: 20px;
            padding: 10px 25px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
        }

        button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    @include('dashboard.nav.nav')
    <form class="add-item-form" action="{{ route('categories.store') }}" method="POST">
        @if (session('success'))
            <div class="success">{{ session('success') }}</div>
        @endif
        @if ($errors->any())
            <div class="error">
                @foreach ($errors->all() as $error)
                    <p>{{ $error }}</p>
                @endforeach
            </div>
        @endif
        @csrf
        
        <label>اسم القسم:</label>
        <input type="text" name="name" required>

        <button type="submit">إضافة</button>
    </form>
</body>
</html>
