<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/x-icon" href="{{ asset('storage/' . $restaurant->logo) }}">
    <title>لوحة التحكم</title>
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }

        h2 {
            text-align: center;
            color: #343a40;
        }

        h3 {
            margin-top: 40px;
            color: #495057;
        }

        ul {
            list-style-type: none;
            padding: 0;
            margin-bottom: 30px;
            display: flex;
            justify-content: center;
        }

        li {
            background-color: #ffffff;
            margin-bottom: 10px;
            padding: 12px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }


        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #212529;
        }

        input[type="text"],
        input[type="number"],
        select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            margin-top: 5px;
        }

        

        hr {
            margin: 50px 0;
            border: none;
            border-top: 1px solid #dee2e6;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-family: 'Cairo', sans-serif;
            direction: rtl;
            background-color: #fff;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            border-radius: 10px;
            overflow: hidden;
        }

        thead {
            background-color: #f8f8f8;
        }

        th, td {
            padding: 12px 20px;
            text-align: center;
            border-bottom: 1px solid #eee;
        }

        th {
            color: #333;
            font-size: 16px;
        }

        td {
            font-size: 15px;
            color: #555;
        }

        tr:hover {
            background-color: #f0f0f0;
        }

        a {
            background-color: #3490dc;
            color: #fff;
            padding: 6px 12px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 14px;
            transition: background-color 0.3s ease;
        }

        a:hover {
            background-color: #2779bd;
        }
        .delete-button {
            background-color: #e3342f;
            color: #fff;
            border: none;
            padding: 6px 12px;
            border-radius: 5px;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            margin-right: 5px;
        }

        .delete-button:hover {
            background-color: #cc1f1a;
        }

    </style>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
</head>
<body>

    @include('dashboard.nav.nav')

    <h2>لوحة التحكم</h2>

    <h3>الأقسام</h3>
    <a href="{{ route('add_categories') }}">إضافة قسم جديد</a>
    <ul>
        @foreach($categories as $category)
            <a href="{{ route('categories.edit', $category->id) }}" style="padding: 0;color: black;background-color: #00000000;">
                <li>{{ $category->name }}</li>
            </a>
        @endforeach
    </ul>

    <h3>الاصناف</h3>
    <a href="{{ route('add_items') }}">إضافة صنف جديد</a>
    <table>
        <thead>
            <tr>
                <th>الاسم</th>
                <th>السعر صغير</th>
                <th>السعر وسط</th>
                <th>السعر كبير</th>
                <th>القسم</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($items as $item)
                <tr>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->priceS }}</td>
                    <td>{{ $item->priceM }}</td>
                    <td>{{ $item->priceL }}</td>
                    <td>{{ $item->category->name ?? 'بدون قسم' }}</td>
                    <td>
                        <a href="{{ route('items.edit', $item->id) }}">تعديل</a>
                        <form action="{{ route('items.destroy', $item->id) }}" method="POST" style="display: inline-block;" onsubmit="return confirm('هل أنت متأكد من حذف هذا المنتج؟');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="delete-button">حذف</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>


    <hr>



</body>
</html>
