
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        .add-item-form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            max-width: 600px;
            margin: auto;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-top: 50px;
            display: flex;
            flex-direction: column;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #212529;
        }

        input[type="text"],
        input[type="number"],
        select {
            /* width: 100%; */
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            margin-top: 5px;
        }

        button {
            margin-top: 20px;
            padding: 10px 25px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
        }

        button:hover {
            background-color: #218838;
        }
        .delete-button {
            background-color: #e3342f;
            
        }

        .delete-button:hover {
            background-color: #cc1f1a;
        }
    </style>
</head>
<body>
    
    <?php echo $__env->make('dashboard.nav.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container mt-5">
    <h2 class="mb-4">تعديل القسم</h2>

    <form action="<?php echo e(route('categories.destroy', $category->id)); ?>" method="POST" style="display: inline-block;" onsubmit="return confirm('هل أنت متأكد من حذف هذا القسم');">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" class="delete-button">حذف</button>
    </form>

    

    <form class="add-item-form" method="POST" action="<?php echo e(route('categories.update', $category->id)); ?>">
        <?php if(session('success')): ?>
            <div class="success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

            <label for="name" class="form-label">الاسم</label>
            <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $category->name)); ?>" required>

        <button type="submit" class="btn btn-primary">تحديث</button>
    </form>
</div>

</body>
</html><?php /**PATH /home/egysyrne/menu.egysyr.net/1/resources/views/dashboard/edit_categories.blade.php ENDPATH**/ ?>