<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تسجيل بيانات المطعم</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
            direction: rtl;
        }

        .container {
            max-width: 500px;
            margin: 60px auto;
            background-color: #ffffff;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: bold;
        }

        
        input{
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 15px;
        }

        button[type="submit"] {
            width: 100%;
            background-color: #28a745;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button[type="submit"]:hover {
            background-color: #218838;
        }

        .errors {
            color: red;
            margin-top: 15px;
        }

        .errors ul {
            padding: 0;
            margin: 0;
            list-style: none;
        }
    </style>
</head>
<body>

    <div class="container">
        <h2>تسجيل بيانات المطعم</h2>

        <form method="POST" action="<?php echo e(route('restaurant.store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <label>اسم المطعم</label>
            <input type="text" name="name" required>

            <label>اللوجو</label>
            <input type="file" name="logo">

            <label>حجم اللوجو في المنيو بالبكسل (انسب حجم 50)</label>
            <input type="number" value="50" name="logo_size" required>

            <label>اسم المستخدم</label>
            <input type="text" name="username" required>

            <label>كلمة المرور</label>
            <input type="password" name="password" required>

            <button type="submit">تسجيل</button>

            <?php if($errors->any()): ?>
                <div class="errors">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </form>
    </div>

</body>
</html>
<?php /**PATH E:\xampp\htdocs\menu-project\resources\views/restaurant/register.blade.php ENDPATH**/ ?>